-- Inventory
-- Version 1.01 
-- Edited by Robbis_1 (aka Killer HAHA) for UCRPM use
-- Written by Night-Eagle

RoleplayData.Inventory = {}

RoleplayData.Inventory.directory = "gamemodes/UCRPM/items" -- Items directory, no trailing or leading slashes, root is "lua/"

RoleplayData.Inventory.slot = 24563		-- Starting GMod text and rect slot
										-- Note that the aspect ratio of the client's screen is taken into consideration.
RoleplayData.Inventory.border = .02		-- Border size of inventory
RoleplayData.Inventory.corx = .2		-- Top-left corner of the screen (The border will protrude past these coordinates)
RoleplayData.Inventory.cory = .2
RoleplayData.Inventory.sizex = 8		-- Number of slots
RoleplayData.Inventory.sizey = 5
RoleplayData.Inventory.scale = .04		-- Y size of individual slot
RoleplayData.Inventory.weight = RoleplayData.MaxWeight		-- Maximum weight (in kilograms) a player can carry. (45.36 kg = 100 lbs)
RoleplayData.Inventory.obj = {}
RoleplayData.Inventory.formula = {}

-- Item function notes
-- onRemove(userid,stackforceremoved(true/false))

for i = 1, _MaxPlayers() do
	RoleplayData[i].inventory = {} -- Lowercase for matchcase replace
	RoleplayData[i].inventory.enable = true
	RoleplayData[i].inventory.open = 0
	RoleplayData[i].inventory.weight = 0
	RoleplayData[i].inventory.curx = nil -- Niled values for reference
	RoleplayData[i].inventory.cury = nil
	RoleplayData[i].inventory.acty = nil
	RoleplayData[i].inventory.combine = nil
	RoleplayData[i].inventory.movx = nil
	RoleplayData[i].inventory.movy = nil
	RoleplayData[i].inventory.screen = nil
	RoleplayData[i].inventory.posx = nil
	RoleplayData[i].inventory.posy = nil
	RoleplayData[i].inventory.aspectratio = 5/4 -- Common LCD Size.
	RoleplayData[i].inventory.store = {} 	-- This is the only table you need to carryover to save all data.
											-- Call both reparseSTRAYobj and recountweight after restoring saved data.
	for x = 1, RoleplayData.Inventory.sizex do
		RoleplayData[i].inventory.store[x] = {}
		for y = 1, RoleplayData.Inventory.sizey do
			RoleplayData[i].inventory.store[x][y] = {}
		end
	end
end

-- Refresh constants
RoleplayData.Inventory.slotnext = RoleplayData.Inventory.slot + RoleplayData.Inventory.sizex * RoleplayData.Inventory.sizey

function RoleplayData.ShowInventory(userid)
	_TraceLine(_PlayerGetShootPos(userid), _PlayerGetShootAng(userid), RoleplayData.UseRange, userid)
	if not _TraceHit() or _TraceHitWorld() then
	RoleplayData.Inventory.Toggle(userid)
	end
end

function RoleplayData.Inventory.reparseSTRAYobj(userid)
	for x = 1, RoleplayData.Inventory.sizex do
		for y = 1, RoleplayData.Inventory.sizey do
			if RoleplayData.Inventory.obj[RoleplayData[userid].inventory.store[x][y].name].name == nil then
				if string.find(RoleplayData[userid].inventory.store[x][y].name,".mdl") ~= nil then	
					local temp = _EntCreate("prop_physics")
					_EntPrecacheModel(RoleplayData[userid].inventory.store[x][y].name)
					_EntSetModel(temp,RoleplayData[userid].inventory.store[x][y].name)
					_EntSpawn(temp)
					RoleplayData.Inventory.parseSTRAYobj(prop)
					_EntRemove(temp)
				end
			end
		end
	end
end

function RoleplayData.Inventory.recountweight(userid)
	RoleplayData[userid].inventory.weight = 0
	for x = 1, RoleplayData.Inventory.sizex do
		for y = 1, RoleplayData.Inventory.sizey do
			if RoleplayData[userid].inventory.store[x][y].name then
				local weight = RoleplayData.Inventory.obj[RoleplayData[userid].inventory.store[x][y].name].weight
				local stack = RoleplayData[userid].inventory.store[x][y].stack
				if weight ~= nil and stack ~= nil then
					RoleplayData[userid].inventory.weight = RoleplayData[userid].inventory.weight + weight*stack
				end
			end
		end
	end
	RoleplayData.Inventory.DispWeight(userid)
end

function RoleplayData.Inventory.hasitem(userid,item)
	local coords = {nil,nil,0}
	for x = 1, RoleplayData.Inventory.sizex do
		for y = 1, RoleplayData.Inventory.sizey do
			if RoleplayData[userid].inventory.store[x][y].name == item then
				coords[1] = x
				coords[2] = y
				coords[3] = coords[3] + RoleplayData[userid].inventory.store[x][y].stack
			end
		end
	end
	if coords[1] then
		return coords
	else
		return {0,0,0}
	end
end

function RoleplayData.Inventory.aspectratio(userid,ratio) -- Not a console command!
	RoleplayData[userid].inventory.aspectratio = ratio
	RoleplayData.Inventory.Hide(userid)
end

function RoleplayData.Inventory.parseobj(file)
	local contents = _file.Read("lua/"..file)
	local funks = {"datName","datDispName","datDescription","datWeight","datStack","datMaterial","onUse","onPickup","onDrop","onRemove","onThink"}
	local fail = nil
	for k,v in funks do
		if string.find(contents,v) == nil then
			fail = true
		end
	end
	if fail then
		return nil
	end
	_OpenScript(file)
	local name
	for k,v in funks do
		if v == "datName" then
			name = datName()
			RoleplayData.Inventory.obj[name] = {}
		elseif v == "datDispName" then
			RoleplayData.Inventory.obj[name].name = datDispName()
		elseif v == "datDescription" then
			RoleplayData.Inventory.obj[name].description = datDescription()
		elseif v == "datWeight" then
			RoleplayData.Inventory.obj[name].weight = datWeight()
		elseif v == "datStack" then
			RoleplayData.Inventory.obj[name].stack = datStack()
		elseif v == "datMaterial" then
			RoleplayData.Inventory.obj[name].material = datMaterial()
		else
			_RunString("temp = "..v) -- v is a string and we want the variable
			RoleplayData.Inventory.obj[name][v] = temp
		end
	end
	return true
end

function RoleplayData.Inventory.parseformula(file)
	local contents = _file.Read("lua/"..file)
	local funks = {"datName","datDescription","datReagents","datTools","datProducts"}
	local fail = nil
	for k,v in funks do
		if string.find(contents,v) == nil then
			fail = true
		end
	end
	if fail then
		return nil
	end
	_OpenScript(file)
	local name
	for k,v in funks do
		if v == "datName" then
			name = datName()
			RoleplayData.Inventory.formula[name] = {}
		elseif v == "datDescription" then
			RoleplayData.Inventory.formula[name].description = datDescription()
		else
			_RunString("temp = "..v.."()") -- v is a string and we want the table
			RoleplayData.Inventory.formula[name][v] = temp
		end
	end
	return true
end

function RoleplayData.Inventory.Use(userid,x,y)
	if RoleplayData.Inventory.obj[RoleplayData[userid].inventory.store[x][y].name].onUse(userid) then
		qty = RoleplayData[userid].inventory.store[x][y].qty
		
		if qty then
			if qty > 1 then
				RoleplayData[userid].inventory.store[x][y].qty = qty - 1
			else
				RoleplayData.Inventory.Remove(userid,x,y)
			end
		else
			RoleplayData.Inventory.Remove(userid,x,y)
		end
		return true
	end
	return false
end

function RoleplayData.Inventory.Pickup(userid,item)
	if RoleplayData.Inventory.obj[item] == nil then
		return "baditem"
	end
	local x
	local y
	local px
	local py
	local fail = true
	
	for ry = 1, RoleplayData.Inventory.sizey do
		for rx = 1, RoleplayData.Inventory.sizex do
			local tx = RoleplayData.Inventory.sizex - rx + 1
			local ty = RoleplayData.Inventory.sizey - ry + 1
			if RoleplayData[userid].inventory.store[tx][ty].name == nil then
				x = tx
				y = ty
				fail = nil
			end
			if RoleplayData[userid].inventory.store[tx][ty].name == item and RoleplayData[userid].inventory.store[tx][ty].stack < RoleplayData.Inventory.obj[item].stack then
				px = tx
				py = ty
				fail = nil
			end
		end
	end
	
	if fail then
		return "space"
	end
	
	if RoleplayData[userid].inventory.weight + RoleplayData.Inventory.obj[item].weight > RoleplayData.Inventory.weight then
		return "weight"
	end
	
	RoleplayData[userid].inventory.weight = RoleplayData[userid].inventory.weight + RoleplayData.Inventory.obj[item].weight
	
	if px then
		x = px -- See below for justification, function call after this block.
		y = py
		RoleplayData[userid].inventory.store[x][y].stack = RoleplayData[userid].inventory.store[x][y].stack + 1
	else
		RoleplayData[userid].inventory.store[x][y].name = item
		RoleplayData[userid].inventory.store[x][y].stack = 1
	end
	
	RoleplayData.Inventory.UpdateItemSlot(userid,x,y)
	RoleplayData.Inventory.obj[RoleplayData[userid].inventory.store[x][y].name].onPickup(userid)
	return "success"
end

function RoleplayData.Inventory.Drop(userid,x,y)
	local kill
	local stackcount = RoleplayData[userid].inventory.store[x][y].stack
	if stackcount == nil then
		return
	elseif stackcount == 1 then
		kill = true
	end
	
	--RoleplayData[userid].inventory.weight = RoleplayData[userid].inventory.weight - RoleplayData.Inventory.obj[RoleplayData[userid].inventory.store[x][y].name].weight
	
	if RoleplayData.Inventory.obj[RoleplayData[userid].inventory.store[x][y].name].onDrop(userid) then
		if kill then
			RoleplayData[userid].inventory.store[x][y] = {}
		else
			RoleplayData[userid].inventory.store[x][y].stack = RoleplayData[userid].inventory.store[x][y].stack - 1
		end
		RoleplayData.Inventory.UpdateItemSlot(userid,x,y)
		RoleplayData.Inventory.recountweight(userid)
		return true
	end
	return false
end

function RoleplayData.Inventory.Remove(userid,x,y,all) -- All removes the entire stack
	local kill
	local stackcount = RoleplayData[userid].inventory.store[x][y].stack
	if stackcount == nil then
		return
	elseif stackcount == 1 or all then
		kill = true
	end
	
	--RoleplayData[userid].inventory.weight = RoleplayData[userid].inventory.weight - RoleplayData.Inventory.obj[RoleplayData[userid].inventory.store[x][y].name].weight
	
	RoleplayData.Inventory.obj[RoleplayData[userid].inventory.store[x][y].name].onRemove(userid,all) --"Warning: Once for entire stack. Because of this, the second arg is true.
	
	if kill then
		RoleplayData[userid].inventory.store[x][y] = {}
	else
		RoleplayData[userid].inventory.store[x][y].stack = RoleplayData[userid].inventory.store[x][y].stack - 1
	end
	RoleplayData.Inventory.UpdateItemSlot(userid,x,y)
	RoleplayData.Inventory.recountweight(userid)
end

-- " GUI Interface

function RoleplayData.Inventory.defscheme()
	_GModRect_Start("GMOD/white")
	_GModRect_SetTime(999999,0,0)
	_GModRect_SetDelay(0)
	
	_GModText_Start("Default")
	_GModText_SetTime(999999,0,0)
	_GModText_SetDelay(0)
	
	--[[
	_GModRect_SetColor(0,0,0,128)
	_GModRect_SetPos(0,0,1,1)
	_GModRect_Send(userid,RoleplayData.Inventory.slot)
	
	_GModText_SetColor(255,255,255,255)
	_GModText_SetPos(.1,.1)
	_GModText_SetText("Players")
	_GModText_Send(userid,RoleplayData.Inventory.slot)
	]]
end

function RoleplayData.Inventory.DispWeight(userid)
	if RoleplayData[userid].inventory.open > 0 then
		RoleplayData.Inventory.defscheme()
		_GModText_SetColor(255,255,255,255)
		_GModText_SetPos(
		RoleplayData.Inventory.corx,
		RoleplayData.Inventory.cory + RoleplayData.Inventory.sizey * RoleplayData.Inventory.scale * RoleplayData[userid].inventory.aspectratio
		)
		_GModText_SetText(RoleplayData[userid].inventory.weight.." kg / "..RoleplayData.Inventory.weight.." kg")
		_GModText_Send(userid,RoleplayData.Inventory.slotnext + 2)
	end
end

function RoleplayData.Inventory.Action(userid,action) -- Input with GUI open
	if RoleplayData[userid].inventory.enable and RoleplayData[userid].inventory.screen then
		RoleplayData.Inventory.defscheme()
		
		local x = RoleplayData[userid].inventory.posx
		local y = RoleplayData[userid].inventory.posy
		local item = RoleplayData[userid].inventory.store[x][y].name
		
		if item then
			if action == "use" then
				RoleplayData.Inventory.Use(userid,x,y)
			elseif action == "drop" then
				RoleplayData.Inventory.Drop(userid,x,y)
			end
		end
	else
		RoleplayData.Inventory.Hide(userid)
	end
end

function RoleplayData.Inventory.Hide(userid)
	RoleplayData.Inventory.HideAction(userid) -- Must be called before RoleplayData[userid].inventory.open is set to 0
	RoleplayData[userid].inventory.open = 0
	--_PlayerLockInPlace(userid,false) -- Commented out for various reasons. (Player can freeze in mid-air, police arrest, etc.)
	_PlayerSetMaxSpeed(userid,190) -- 190 is the default forward speed "FIXME
	for x = 1, RoleplayData.Inventory.sizex do
		for y = 1, RoleplayData.Inventory.sizey do
			local number = RoleplayData.Inventory.slot + ((y-1)*RoleplayData.Inventory.sizex)+x
			_GModRect_Hide(userid,number)
			_GModText_Hide(userid,number)
		end
	end
	_GModRect_Hide(userid,RoleplayData.Inventory.slot)
	_GModText_Hide(userid,RoleplayData.Inventory.slotnext + 2)
	RoleplayData[userid].inventory.curx = nil
	RoleplayData[userid].inventory.cury = nil
	RoleplayData[userid].inventory.movx = nil
	RoleplayData[userid].inventory.movy = nil
	RoleplayData.Inventory.UpdateCursors(userid)
end

function RoleplayData.Inventory.Show(userid)
	RoleplayData[userid].inventory.curx = 1
	RoleplayData[userid].inventory.cury = 1
	RoleplayData[userid].inventory.open = 1 -- Note that this value may be set to 2 as well when the menu is open. Assume if > 0, the menu is open.
	RoleplayData.Inventory.DispWeight(userid) -- Must be called after the open variable is set to 1 or 2
	_PlayerSetMaxSpeed(userid,1) --"FIXME
	if RoleplayData[userid].inventory.enable == false then
		return
	end
	--_PlayerLockInPlace(userid,true) -- Commented out for various reasons. (Player can freeze in mid-air, police arrest, etc.)
	RoleplayData.Inventory.defscheme()
	
	_GModRect_SetColor(0,0,0,200)
	_GModRect_SetPos(
	RoleplayData.Inventory.corx-RoleplayData.Inventory.border,
	RoleplayData.Inventory.cory-RoleplayData.Inventory.border*RoleplayData[userid].inventory.aspectratio,
	(RoleplayData.Inventory.sizex*RoleplayData.Inventory.scale)+(RoleplayData.Inventory.border*2),
	(RoleplayData.Inventory.sizey*RoleplayData.Inventory.scale*RoleplayData[userid].inventory.aspectratio)+(RoleplayData.Inventory.border*2*RoleplayData[userid].inventory.aspectratio)
	)
	_GModRect_Send(userid,RoleplayData.Inventory.slot)
	
	--[[
	RoleplayData.Inventory.sizex = 4 -- Number of slots
	RoleplayData.Inventory.sizey = 4
	RoleplayData.Inventory.scale = .04 -- Y size of individual slot
	]]
	for x = 1, RoleplayData.Inventory.sizex do
		for y = 1, RoleplayData.Inventory.sizey do
			if RoleplayData[userid].inventory.store[x][y].name then
				_GModRect_Start(RoleplayData.Inventory.obj[RoleplayData[userid].inventory.store[x][y].name].material)
				_GModRect_SetTime(999999,0,0)
				_GModRect_SetDelay(0)
				_GModRect_SetColor(255,255,255,200)
				
				if RoleplayData[userid].inventory.store[x][y].stack > 1 then
					_GModText_SetColor(255,0,0,200)
					_GModText_SetText(" "..RoleplayData[userid].inventory.store[x][y].stack)
					_GModText_SetPos(
					RoleplayData.Inventory.corx + RoleplayData.Inventory.scale * (x-1),
					RoleplayData.Inventory.cory + (RoleplayData.Inventory.scale * (y-1) * RoleplayData[userid].inventory.aspectratio)
					)
					_GModText_Send(userid,RoleplayData.Inventory.slot + ((y-1)*RoleplayData.Inventory.sizex)+x)
				else
					_GModText_Hide(userid,RoleplayData.Inventory.slot + ((y-1)*RoleplayData.Inventory.sizex)+x)
				end
				_GModRect_SetPos(
				RoleplayData.Inventory.corx + RoleplayData.Inventory.scale * (x-1),
				RoleplayData.Inventory.cory + (RoleplayData.Inventory.scale * (y-1) * RoleplayData[userid].inventory.aspectratio),
				RoleplayData.Inventory.scale,
				RoleplayData.Inventory.scale*RoleplayData[userid].inventory.aspectratio
				)
				_GModRect_Send(userid,RoleplayData.Inventory.slot + ((y-1)*RoleplayData.Inventory.sizex)+x)
			else
				RoleplayData.Inventory.defscheme()
				_GModRect_Hide(userid,RoleplayData.Inventory.slot + ((y-1)*RoleplayData.Inventory.sizex)+x)
				_GModText_Hide(userid,RoleplayData.Inventory.slot + ((y-1)*RoleplayData.Inventory.sizex)+x)
			end
		end
	end
	RoleplayData.Inventory.UpdateCursors(userid)
end

function RoleplayData.Inventory.UpdateItemSlot(userid,x,y)
	if RoleplayData[userid].inventory.open > 0 then
		if RoleplayData[userid].inventory.store[x][y].name then
			_GModRect_Start(RoleplayData.Inventory.obj[RoleplayData[userid].inventory.store[x][y].name].material)
			_GModRect_SetTime(999999,0,0)
			_GModRect_SetDelay(0)
			_GModRect_SetColor(255,255,255,200)
			
			if RoleplayData[userid].inventory.store[x][y].stack > 1 then
				_GModText_SetColor(255,0,0,200)
				_GModText_SetText(" "..RoleplayData[userid].inventory.store[x][y].stack)
				_GModText_SetPos(
				RoleplayData.Inventory.corx + RoleplayData.Inventory.scale * (x-1),
				RoleplayData.Inventory.cory + (RoleplayData.Inventory.scale * (y-1) * RoleplayData[userid].inventory.aspectratio)
				)
				_GModText_Send(userid,RoleplayData.Inventory.slot + ((y-1)*RoleplayData.Inventory.sizex)+x)
			else
				_GModText_Hide(userid,RoleplayData.Inventory.slot + ((y-1)*RoleplayData.Inventory.sizex)+x)
			end
			_GModRect_SetPos(
			RoleplayData.Inventory.corx + RoleplayData.Inventory.scale * (x-1),
			RoleplayData.Inventory.cory + (RoleplayData.Inventory.scale * (y-1) * RoleplayData[userid].inventory.aspectratio),
			RoleplayData.Inventory.scale,
			RoleplayData.Inventory.scale*RoleplayData[userid].inventory.aspectratio
			)
			_GModRect_Send(userid,RoleplayData.Inventory.slot + ((y-1)*RoleplayData.Inventory.sizex)+x)
		else
			RoleplayData.Inventory.defscheme()
			_GModRect_Hide(userid,RoleplayData.Inventory.slot + ((y-1)*RoleplayData.Inventory.sizex)+x)
			_GModText_Hide(userid,RoleplayData.Inventory.slot + ((y-1)*RoleplayData.Inventory.sizex)+x)
		end
		RoleplayData.Inventory.DispWeight(userid)
	end
end

function RoleplayData.Inventory.HideAction(userid)
	RoleplayData[userid].inventory.open = 1
	RoleplayData[userid].inventory.acty = nil
	
	_GModRect_Hide(userid,RoleplayData.Inventory.slotnext + 2)
	_GModText_Hide(userid,RoleplayData.Inventory.slotnext + 3)
	_GModText_Hide(userid,RoleplayData.Inventory.slotnext + 4)
	_GModText_Hide(userid,RoleplayData.Inventory.slotnext + 5)
	
	
	RoleplayData.Inventory.UpdateCursors(userid)
end

function RoleplayData.Inventory.ShowAction(userid)
	RoleplayData.Inventory.defscheme()
	RoleplayData[userid].inventory.open = 2
	RoleplayData[userid].inventory.acty = 1
	local x = RoleplayData[userid].inventory.curx
	local y = RoleplayData[userid].inventory.cury
	
	_GModRect_SetColor(0,0,0,200)
	_GModRect_SetPos(
	RoleplayData.Inventory.corx + RoleplayData.Inventory.scale * RoleplayData.Inventory.sizex + RoleplayData.Inventory.border,
	RoleplayData.Inventory.cory - RoleplayData.Inventory.border * RoleplayData[userid].inventory.aspectratio,
	1,.165)
	_GModRect_Send(userid,RoleplayData.Inventory.slotnext + 2)
	
	_GModText_SetColor(255,255,255,255)
	_GModText_SetPos(
	RoleplayData.Inventory.corx + RoleplayData.Inventory.scale * RoleplayData.Inventory.sizex + RoleplayData.Inventory.border,
	RoleplayData.Inventory.cory - RoleplayData.Inventory.border * RoleplayData[userid].inventory.aspectratio)
	if RoleplayData.Inventory.obj[RoleplayData[userid].inventory.store[x][y].name].name then
		_GModText_SetText(RoleplayData.Inventory.obj[RoleplayData[userid].inventory.store[x][y].name].name)
		_GModText_Send(userid,RoleplayData.Inventory.slotnext + 3)
	end
	_GModText_SetText(" \nCancel\nUse\nDrop\nMove\nCombine\n\nDestroy")
	_GModText_Send(userid,RoleplayData.Inventory.slotnext + 4)
	if RoleplayData.Inventory.obj[RoleplayData[userid].inventory.store[x][y].name].description then
		_GModText_SetPos(
		RoleplayData.Inventory.corx + RoleplayData.Inventory.scale * RoleplayData.Inventory.sizex + RoleplayData.Inventory.border + .1,
		RoleplayData.Inventory.cory - RoleplayData.Inventory.border * RoleplayData[userid].inventory.aspectratio + .02)
		_GModText_SetText(RoleplayData.Inventory.obj[RoleplayData[userid].inventory.store[x][y].name].weight.." kg\n"..RoleplayData.Inventory.obj[RoleplayData[userid].inventory.store[x][y].name].description)
		_GModText_Send(userid,RoleplayData.Inventory.slotnext + 5)
	end
	
	RoleplayData.Inventory.UpdateCursors(userid)
end

function RoleplayData.Inventory.UpdateCursors(userid)
	if RoleplayData[userid].inventory.open == 0 then
		_GModRect_Hide(userid,RoleplayData.Inventory.slotnext + 1)
		_GModRect_Hide(userid,RoleplayData.Inventory.slotnext + 4)
	else
		local x = RoleplayData[userid].inventory.curx
		local y = RoleplayData[userid].inventory.cury
		local acty = RoleplayData[userid].inventory.acty
		_GModRect_Start("GMOD/white")
		_GModRect_SetTime(999999,0,0)
		_GModRect_SetDelay(0)
		-- (RoleplayData.Inventory.slot + RoleplayData.Inventory.sizex * RoleplayData.Inventory.sizey)
		
		if RoleplayData[userid].inventory.open == 1 then
			_GModRect_SetColor(255,255,0,100)
		else
			_GModRect_SetColor(0,255,0,150)
		end
		_GModRect_SetPos(
		RoleplayData.Inventory.corx + RoleplayData.Inventory.scale * (x-1),
		RoleplayData.Inventory.cory + (RoleplayData.Inventory.scale * (y-1) * RoleplayData[userid].inventory.aspectratio),
		RoleplayData.Inventory.scale,
		RoleplayData.Inventory.scale*RoleplayData[userid].inventory.aspectratio
		)
		_GModRect_Send(userid,RoleplayData.Inventory.slotnext + 1)
		
		if RoleplayData[userid].inventory.open == 2 then
			_GModRect_SetColor(255,255,0,100)
			_GModRect_SetPos(
			RoleplayData.Inventory.corx + RoleplayData.Inventory.scale * RoleplayData.Inventory.sizex + RoleplayData.Inventory.border,
			RoleplayData.Inventory.cory - RoleplayData.Inventory.border * RoleplayData[userid].inventory.aspectratio + RoleplayData[userid].inventory.acty * .0181,
			.1,.02)
			_GModRect_Send(userid,RoleplayData.Inventory.slotnext + 3)
		else
			_GModRect_Hide(userid,RoleplayData.Inventory.slotnext + 3)
		end
		
		if RoleplayData[userid].inventory.movx then
			x = RoleplayData[userid].inventory.movx
			y = RoleplayData[userid].inventory.movy
			_GModRect_SetColor(0,0,255,100)
			_GModRect_SetPos(
			RoleplayData.Inventory.corx + RoleplayData.Inventory.scale * (x-1),
			RoleplayData.Inventory.cory + (RoleplayData.Inventory.scale * (y-1) * RoleplayData[userid].inventory.aspectratio),
			RoleplayData.Inventory.scale,
			RoleplayData.Inventory.scale*RoleplayData[userid].inventory.aspectratio
			)
			_GModRect_Send(userid,RoleplayData.Inventory.slotnext + 4)
		else
			_GModRect_Hide(userid,RoleplayData.Inventory.slotnext + 4)
		end
	end
end

function RoleplayData.Inventory.Toggle(userid) --"FIXME
	if RoleplayData[userid].inventory.open == 0 then
		RoleplayData.Inventory.Show(userid)
	else
		RoleplayData.Inventory.Hide(userid)
	end
end

--"Input
function rpinventory_keypress(userid,key)
	if RoleplayData[userid].inventory.open == 0 then
		if key == IN_SCORE and _PlayerIsKeyDown(userid,IN_DUCK) then
			RoleplayData.Inventory.Show(userid)
		end
		return
	elseif RoleplayData[userid].inventory.open == 1 then
		if key == IN_BACK then
			if RoleplayData[userid].inventory.cury < RoleplayData.Inventory.sizey then
				RoleplayData[userid].inventory.cury = RoleplayData[userid].inventory.cury + 1
			else
				_PlaySoundPlayer(userid,"common/wpn_denyselect.wav")
			end
		elseif key == IN_FORWARD then
			if RoleplayData[userid].inventory.cury > 1 then
				RoleplayData[userid].inventory.cury = RoleplayData[userid].inventory.cury - 1
			else
				_PlaySoundPlayer(userid,"common/wpn_denyselect.wav")
			end
		elseif key == IN_MOVERIGHT then
			if RoleplayData[userid].inventory.curx < RoleplayData.Inventory.sizex then
				RoleplayData[userid].inventory.curx = RoleplayData[userid].inventory.curx + 1
			else
				_PlaySoundPlayer(userid,"common/wpn_denyselect.wav")
			end
		elseif key == IN_MOVELEFT then
			if RoleplayData[userid].inventory.curx > 1 then
				RoleplayData[userid].inventory.curx = RoleplayData[userid].inventory.curx - 1
			else
				_PlaySoundPlayer(userid,"common/wpn_denyselect.wav")
			end
		elseif key == IN_USE then
			if RoleplayData[userid].inventory.movx == nil then
				if RoleplayData[userid].inventory.store[RoleplayData[userid].inventory.curx][RoleplayData[userid].inventory.cury].name then
					RoleplayData.Inventory.ShowAction(userid)
					RoleplayData[userid].inventory.open = 2
				else
					_PlaySoundPlayer(userid,"common/wpn_denyselect.wav")
				end
			elseif RoleplayData[userid].inventory.combine == nil then
				local curx = RoleplayData[userid].inventory.curx
				local cury = RoleplayData[userid].inventory.cury
				local movx = RoleplayData[userid].inventory.movx
				local movy = RoleplayData[userid].inventory.movy
				if RoleplayData[userid].inventory.store[curx][cury].name then
					RoleplayData[userid].inventory.store[curx][cury].name,RoleplayData[userid].inventory.store[movx][movy].name = RoleplayData[userid].inventory.store[movx][movy].name,RoleplayData[userid].inventory.store[curx][cury].name
					RoleplayData[userid].inventory.store[curx][cury].stack,RoleplayData[userid].inventory.store[movx][movy].stack = RoleplayData[userid].inventory.store[movx][movy].stack,RoleplayData[userid].inventory.store[curx][cury].stack
				else
					RoleplayData[userid].inventory.store[curx][cury].name = RoleplayData[userid].inventory.store[movx][movy].name
					RoleplayData[userid].inventory.store[curx][cury].stack = RoleplayData[userid].inventory.store[movx][movy].stack
					RoleplayData[userid].inventory.store[movx][movy].name = nil
					RoleplayData[userid].inventory.store[movx][movy].stack = nil
				end
				RoleplayData.Inventory.UpdateItemSlot(userid,curx,cury)
				RoleplayData.Inventory.UpdateItemSlot(userid,movx,movy)
				RoleplayData[userid].inventory.movx = nil
				RoleplayData[userid].inventory.movy = nil
			elseif RoleplayData[userid].inventory.combine == true then
				local curx = RoleplayData[userid].inventory.curx
				local cury = RoleplayData[userid].inventory.cury
				local movx = RoleplayData[userid].inventory.movx
				local movy = RoleplayData[userid].inventory.movy
				local itema = RoleplayData[userid].inventory.store[curx][cury].name
				local itemb = RoleplayData[userid].inventory.store[movx][movy].name
				if RoleplayData[userid].inventory.store[curx][cury].name then
					if itema == itemb then
						if (cury*RoleplayData.Inventory.sizex)+curx  ~= (movy*RoleplayData.Inventory.sizex)+movx then
							local max = RoleplayData.Inventory.obj[itema].stack
							local count = RoleplayData[userid].inventory.store[curx][cury].stack+RoleplayData[userid].inventory.store[movx][movy].stack
							local mod = math.mod(count,max)
							if mod > 0 and count > max then
								RoleplayData[userid].inventory.store[curx][cury].stack = max
								RoleplayData[userid].inventory.store[movx][movy].stack = mod
							else
								RoleplayData[userid].inventory.store[curx][cury].stack = count
								RoleplayData[userid].inventory.store[movx][movy].stack = nil
								RoleplayData[userid].inventory.store[movx][movy].name = nil
							end
						end
						RoleplayData.Inventory.UpdateItemSlot(userid,curx,cury)
						RoleplayData.Inventory.UpdateItemSlot(userid,movx,movy)
						RoleplayData[userid].inventory.movx = nil
						RoleplayData[userid].inventory.movy = nil
						RoleplayData[userid].inventory.combine = nil
					else
						local transaction = false
						for k,v in RoleplayData.Inventory.formula do
							if transaction == false then
								local fail = false
								local fullone = false
								local fulltwo = false
								for item,qty in v.datReagents do
									if RoleplayData.Inventory.hasitem(userid,item)[3] < qty then
										fail = true
									end
									if item == itema then
										fullone = true
									elseif item == itemb then
										fulltwo = true
									end
								end
								for item,qty in v.datTools do
									if RoleplayData.Inventory.hasitem(userid,item)[3] < qty then
										fail = true
									end
								end
								if fail == false and fullone and fulltwo then
									transaction = true
									for item,qty in v.datReagents do
										for i = 1, qty do
											local coords = RoleplayData.Inventory.hasitem(userid,item)
											RoleplayData.Inventory.Remove(userid,coords[1],coords[2])
										end
									end
									for item,qty in v.datProducts do
										for i = 1, qty do
											RoleplayData.Inventory.Pickup(userid,item)
										end
									end
								end
							end
						end
					end
					RoleplayData.Inventory.UpdateItemSlot(userid,curx,cury)
					RoleplayData.Inventory.UpdateItemSlot(userid,movx,movy)
					RoleplayData[userid].inventory.movx = nil
					RoleplayData[userid].inventory.movy = nil
					RoleplayData[userid].inventory.combine = nil
				else
					_PlaySoundPlayer(userid,"common/wpn_denyselect.wav")
				end
			end
		end
		RoleplayData.Inventory.UpdateCursors(userid)
	elseif RoleplayData[userid].inventory.open == 2 then
		if key == IN_BACK then
			if RoleplayData[userid].inventory.acty < 7 then
				RoleplayData[userid].inventory.acty = RoleplayData[userid].inventory.acty + 1
			else
				_PlaySoundPlayer(userid,"common/wpn_denyselect.wav")
			end
		elseif key == IN_FORWARD then
			if RoleplayData[userid].inventory.acty > 1 then
				RoleplayData[userid].inventory.acty = RoleplayData[userid].inventory.acty - 1
			else
				_PlaySoundPlayer(userid,"common/wpn_denyselect.wav")
			end
		elseif key == IN_MOVELEFT then
			RoleplayData[userid].inventory.open = 1
			RoleplayData.Inventory.HideAction(userid)
		elseif key == IN_USE then
			local x = RoleplayData[userid].inventory.curx
			local y = RoleplayData[userid].inventory.cury
			local acty = RoleplayData[userid].inventory.acty
			local fail = false
			if acty == 1 then
				RoleplayData[userid].inventory.open = 1
				RoleplayData.Inventory.HideAction(userid)
			elseif acty == 2 then
				RoleplayData.Inventory.Use(userid,x,y)
			elseif acty == 3 then
				RoleplayData.Inventory.Drop(userid,x,y)
			elseif acty == 4 then
				RoleplayData[userid].inventory.movx = x
				RoleplayData[userid].inventory.movy = y
			elseif acty == 5 then
				RoleplayData[userid].inventory.movx = x
				RoleplayData[userid].inventory.movy = y
				RoleplayData[userid].inventory.combine = true
			elseif acty == 6 then
				fail = true
			elseif acty == 7 then
				RoleplayData.Inventory.Remove(userid,x,y)
			end
			if fail then
				_PlaySoundPlayer(userid,"common/wpn_denyselect.wav")
			else
				RoleplayData[userid].inventory.open = 1
				RoleplayData.Inventory.HideAction(userid)
			end
		end
		RoleplayData.Inventory.UpdateCursors(userid)
	end
	if key == IN_JUMP or key == IN_DUCK then
		RoleplayData.Inventory.Hide(userid)
	end
end

-- "Stray prop autoparser
function inventorydonothing()
end

function RoleplayData.Inventory.parseSTRAYobj(prop)
	local funks = {"datName","datDispName","datDescription","datWeight","datStack","datMaterial","onUse","onPickup","onDrop","onRemove","onThink"}
	local name
	for k,v in funks do
		if v == "datName" then
			name = _EntGetModel(prop)
			RoleplayData.Inventory.obj[name] = {}
		elseif v == "datDispName" then
			RoleplayData.Inventory.obj[name].name = string.sub(_EntGetModel(prop),1,-5)
		elseif v == "datDescription" then
			RoleplayData.Inventory.obj[name].description = "A prop."
		elseif v == "datWeight" then
			local temp = _EntCreate("prop_physics") -- This prevents mass changing of the prop so an accurate mass is yielded.
			_EntPrecacheModel(_EntGetModel(prop))
			_EntSetModel(temp,_EntGetModel(prop))
			_EntSpawn(temp)
			local mass = _phys.GetMass(temp)
			_EntRemove(temp)
			RoleplayData.Inventory.obj[name].weight = mass
		elseif v == "datStack" then
			RoleplayData.Inventory.obj[name].stack = 100
		elseif v == "datMaterial" then
			RoleplayData.Inventory.obj[name].material = "Effects/ar2_altfire1.vmt"
		elseif v == "onUse" or v == "onDrop" then
			_RunString([[
			function tempinventoryspawn(userid)
				_TraceLine(_PlayerGetShootPos(userid),_PlayerGetShootAng(userid),128,userid)
				local thething = _EntCreate("prop_physics")
				_EntPrecacheModel("]].._EntGetModel(prop)..[[")
				_EntSetModel(thething,"]].._EntGetModel(prop)..[[")
				_EntSetPos(thething,_TraceEndPos())
				_EntSpawn(thething)
				return true
			end
			]])
			RoleplayData.Inventory.obj[name][v] = tempinventoryspawn
		else
			RoleplayData.Inventory.obj[name][v] = inventorydonothing
		end
	end
	return true
end

function rpinventory_useentity(userid,entity)
	if _PlayerIsKeyDown(userid,IN_SPEED) then
		for k,v in RoleplayData.Inventory.obj do
			if _EntGetName(entity) == k then
				if RoleplayData.Inventory.Pickup(userid,k) == "success" then
					_EntRemove(entity)
				end
				return
			end
		end
		--[[if _EntGetType(entity) == "prop_physics" and string.len(_EntGetName(entity)) < 1 then
			RoleplayData.Inventory.parseSTRAYobj(entity)
			if RoleplayData.Inventory.Pickup(userid,_EntGetModel(entity)) == "success" then
				_EntRemove(entity)
			end
		end]]
		if _EntGetType(entity) == "prop_physics" then
			local noexist = true
			for k,v in RoleplayData.Inventory.obj do
				if _EntGetName(entity) == k then
				noexist = false
				end
			end
			if noexist then
				RoleplayData.Inventory.parseSTRAYobj(entity)
				if RoleplayData.Inventory.Pickup(userid,_EntGetModel(entity)) == "success" then
					_EntRemove(entity)
				end
			end
		end
	end
end

-- "Autoexec
for k,v in _file.Find("lua/"..RoleplayData.Inventory.directory.."/*.item") do
	RoleplayData.Inventory.parseobj(RoleplayData.Inventory.directory.."/"..v)
end
for k,v in _file.Find("lua/"..RoleplayData.Inventory.directory.."/*.formula") do
	RoleplayData.Inventory.parseformula(RoleplayData.Inventory.directory.."/"..v)
end

-- "Hooks

if rp_inventory_hook == nil then
	rp_inventory_hook = HookEvent("eventKeyPressed",rpinventory_keypress)
else
	UnHookEvent(rp_inventory_hook)
	rp_inventory_hook = HookEvent("eventKeyPressed",rpinventory_keypress)
end
if rp_inventory_hooka == nil then
	rp_inventory_hooka = HookEvent("eventPlayerUseEntity",rpinventory_useentity)
else
	UnHookEvent(rp_inventory_hook)
	rp_inventory_hooka = HookEvent("eventPlayerUseEntity",rpinventory_useentity)
end

CONCOMMAND("+rp_showinventory",RoleplayData.Inventory.Show)
CONCOMMAND("-rp_showinventory",RoleplayData.Inventory.Hide)
CONCOMMAND("rp_showinventory",RoleplayData.Inventory.Show)
CONCOMMAND("rp_hideinventory",RoleplayData.Inventory.Hide)
CONCOMMAND("rp_toggleinventory",RoleplayData.Inventory.Toggle)